IF OBJECT_ID('CD_Clientes_Novedades', 'U') IS NULL
BEGIN

	CREATE TABLE CD_Clientes_Novedades(
		Id_Novedad INT IDENTITY(0,1) NOT NULL,
		Id_Cliente INT NULL,
		Fecha DATETIME NULL,
		Estado CHAR(1) NULL,
		Fecha_Simulacion DATETIME NULL,
	 CONSTRAINT PK_CDCLNV_PorId PRIMARY KEY CLUSTERED 
		(
			Id_Novedad ASC
		)
	)
END
GO


IF IndexProperty(Object_Id('CD_Clientes_Novedades'), 'IX_CDCLNV_PorCliEstFecha', 'IndexID') IS NULL
	CREATE INDEX IX_CDCLNV_PorCliEstFecha ON CD_Clientes_Novedades (Id_Cliente,Estado,Fecha)

GO


IF OBJECT_ID('FK_CDCLNV_Clientes', 'F') IS NULL
BEGIN
	ALTER TABLE CD_Clientes_Novedades  ADD  CONSTRAINT FK_CDCLNV_Clientes FOREIGN KEY(Id_Cliente)  REFERENCES Clientes (Id_Cliente)
END
GO


IF COL_LENGTH('CD_Clientes_Novedades', 'Tipo') IS NULL
BEGIN
    ALTER TABLE CD_Clientes_Novedades ADD Tipo CHAR(1) DEFAULT 'A';
END
GO

IF COL_LENGTH('CD_Clientes_Novedades', 'Nota') IS NULL
BEGIN
    ALTER TABLE CD_Clientes_Novedades ADD Nota VARCHAR(100)
END
GO


DECLARE @ConstraintName NVARCHAR(255);
DECLARE @SQL NVARCHAR(MAX);

-- Buscar el nombre de la constraint DEFAULT existente (si la hay)
SELECT @ConstraintName = dc.name
	FROM sys.default_constraints dc
	INNER JOIN sys.columns c ON c.default_object_id = dc.object_id
	WHERE dc.parent_object_id = OBJECT_ID('CD_Clientes_Novedades')
	  AND c.name = 'Fecha';


IF @ConstraintName IS NULL
BEGIN
	-- Agregar nueva constraint DEFAULT con GETDATE()
	ALTER TABLE CD_Clientes_Novedades
	ADD CONSTRAINT DF_CDCN_Fecha DEFAULT GETDATE() FOR Fecha;
END

---------------------------------------------------------------------
SELECT @ConstraintName = dc.name
	FROM sys.default_constraints dc
	INNER JOIN sys.columns c ON c.default_object_id = dc.object_id
	WHERE dc.parent_object_id = OBJECT_ID('CD_Clientes_Novedades')
	  AND c.name = 'Estado';


IF @ConstraintName IS NULL
BEGIN
	-- Agregar nueva constraint DEFAULT con GETDATE()
	ALTER TABLE CD_Clientes_Novedades
	ADD CONSTRAINT DF_CDCN_Estado DEFAULT 'P' FOR Estado;
END
